//	 	  ^^AAZJ BOSSNIK^^
//		^^EXP-WAVE SYNTH^^

//TO DO:
//de-click: inertia
//optimize
//polyphony


//INCLUDES

#include "C:\Program Files\Buzz\Dev\MachineInterface.h"
#include <math.h>

//DEFINES

#define MAXAMP 32768.0f
#define CZERO 16.3516f  

//GLOBAL PARAMETERS

CMachineParameter const paraPulsewidth = 
{
	pt_word,
	"OSC/Pulsewidth", 
	"Oscillator Pulsewidth, 0000-FFFE",  
	0,                          
	0xfffe,                       
	0xffff,                       
	MPF_STATE,
	0x8000	
};

CMachineParameter const paraOscShape = 
{
	pt_word,
	"OSC/Ramp Shape", 
	"Oscillator Ramp Shape, 0000-FFFE",  
	0,                          
	0xfffe,                       
	0xffff,                       
	MPF_STATE,
	0x8000	
};

CMachineParameter const paraAttack = 
{
	pt_word,
	"AMP/Attack", 
	"Amplifier Attack Time in ms, 0000-FFFE",  
	0,                          
	0xfffe,                       
	0xffff,                       
	MPF_STATE,
	0x20	
};

CMachineParameter const paraDecay = 
{
	pt_word,
	"AMP/Decay", 
	"Amplifier Decay Time in ms, 0000-FFFE",  
	0,                          
	0xfffe,                       
	0xffff,                       
	MPF_STATE,
	0x80	
};

CMachineParameter const paraSustain = 
{
	pt_word,
	"AMP/Sustain", 
	"Amplifier Sustain Level, 0000-FFFE",  
	0,                          
	0xfffe,                       
	0xffff,                       
	MPF_STATE,
	0x0000	
};

CMachineParameter const paraRelease = 
{
	pt_word,
	"AMP/Release", 
	"Amplifier Release Time in ms, 0000-FFFE",  
	0,                          
	0xfffe,                       
	0xffff,                       
	MPF_STATE,
	0x200	
};

CMachineParameter const paraAmpShape = 
{
	pt_word,
	"AMP/Ramp Shape", 
	"Amplifier Ramp Shape, 0000-FFFE",  
	0,                          
	0xfffe,                       
	0xffff,                       
	MPF_STATE,
	0x8000	
};

//TRACK PARAMETERS

CMachineParameter const paraNote = 
{
	pt_note,
	"Note",  
	"Note",  
	NOTE_MIN,                   
	NOTE_MAX,                  
	NOTE_NO,                   
	0                           
};

CMachineParameter const paraLevel =
{
	pt_byte,
	"Track Level",
	"Track Level",
	0,
	0xfe,
	0xff,
	0,
	0x80
};

//ATTRIBUTES

CMachineAttribute const attrExpRange = 
{
	"Exponential Range",
	2,     
	65536,
	256 
};

//POINTER ARRAYS

CMachineParameter const *pParameters[] =
{
	&paraPulsewidth,
	&paraOscShape,
	&paraAttack,
	&paraDecay,
	&paraSustain,
	&paraRelease,
	&paraAmpShape,
	
	&paraNote,
	&paraLevel
};

CMachineAttribute const *pAttributes[] = 
{
	&attrExpRange
};

//CLASSES

#pragma pack(1)			



class gvals
{
	public:
		word Pulsewidth;
		word OscShape;
		word Attack;
		word Decay;
		word Sustain;
		word Release;
		word AmpShape;
};

class tvals
{
	public:
		byte Note;
		byte Level;
};

class avals
{
	public:
		int ExpRange;
};

#pragma pack()

//MACHINE INFO

#define MAX_TRACKS	1

CMachineInfo const MacInfo = 
{
	MT_GENERATOR,      
	MI_VERSION,
	NULL,
	1,                          
	MAX_TRACKS,          
	7,                 
	2,                 
	pParameters,  
	1,                 
	pAttributes,    
#ifdef _DEBUG
	"Aazj Bossnik (debug build)",  
#else
	"Aazj Bossnik",                
#endif
	"Bossnik",                           
	"Aazj",                    
	NULL                            
};

//MACHINE INTERFACE

class mi : public CMachineInterface
{
public:	
	mi();
	virtual ~mi();	

	virtual void Init(CMachineDataInput * const pi);
	virtual void Tick();
	virtual bool Work(float *psamples, int numsamples, int const mode);
	virtual void SetNumTracks(int const n);

private:	
	int numTracks;
	gvals gval;
	tvals tval;
	avals aval;

	float y,z;

	float pulsewidth;
	float oscshape;
	long attack;
	long decay;
	float sustain;
	long release;
	float ampshape;

	bool gate;
	float oscphase;
	float frequency;
	float amplitude;
	long note_time;
	float oldamp;
	float level;
};

//DLL_EXPORTS 

DLL_EXPORTS

//MI MEMBER FUNCTIONS

mi::mi()	
{
	GlobalVals = &gval;
	TrackVals = &tval;
	AttrVals = (int*)&aval;
}

mi::~mi()
{
}

void mi::Init(CMachineDataInput *const pi)
{

	pulsewidth = 0.5f;
	oscshape = 1.0f;
	attack = 14112;
	decay = 56448;
	sustain = 0.0f;
	release = 225792;
	ampshape =1.0f;

	gate = false;
	oscphase=0.0f;
	frequency=440.0f;
	amplitude=0.0f;
	note_time=65536;
	oldamp=0.0f;
	level=0.5f;
}

void mi::SetNumTracks(int const n)
{
	numTracks = n;
}

void mi::Tick()
{
	if(z!=aval.ExpRange)	//This should probably go somewhere else...
	{
		z=(float)aval.ExpRange;
		y=powf(z,1.0f/32768);
	}	
	
	if(gval.Pulsewidth != paraPulsewidth.NoValue)
		pulsewidth = (float)gval.Pulsewidth/paraPulsewidth.MaxValue;

	if(gval.OscShape != paraOscShape.NoValue)
		oscshape = powf(y,gval.OscShape)/z;

	if(gval.Attack != paraAttack.NoValue)
		attack=(gval.Attack*pMasterInfo->SamplesPerSec)/1000;

	if(gval.Decay != paraDecay.NoValue)
		decay=(gval.Decay*pMasterInfo->SamplesPerSec)/1000;
	
	if(gval.Sustain != paraSustain.NoValue)
		sustain=(MAXAMP*gval.Sustain)/paraSustain.MaxValue;

	if(gval.Release != paraRelease.NoValue)
		release=(gval.Release*pMasterInfo->SamplesPerSec)/1000;

	if(gval.AmpShape != paraAmpShape.NoValue)
		ampshape = powf(y,gval.AmpShape)/z;


	if(tval.Note == NOTE_OFF)
	{
		gate = false;
		note_time=0;
		oldamp=amplitude;
	}
	else if(tval.Note != NOTE_NO)
	{
		gate = true;
		note_time=0;
        frequency =  CZERO * powf(2.0f, ((tval.Note>>4)*12+(tval.Note&0x0f)-1)/12.0f);
		oldamp=amplitude;
	}

	if (tval.Level != paraLevel.NoValue)
		level=(float)tval.Level/paraLevel.MaxValue;
	
}

bool mi::Work(float *psamples, int numsamples, int const mode)
{
	while(numsamples--)
	{
		if (gate)				//ENVELOPE
		{
			if(note_time<attack)
				amplitude = oldamp+powf((float)note_time/attack,ampshape)*(MAXAMP-oldamp);
			else if(note_time<(attack+decay))
				amplitude = MAXAMP-(powf((float)(note_time-attack)/decay,ampshape)*(MAXAMP-sustain));
			else
				amplitude=sustain;
		}
		else
		{
			if(note_time<release)
				amplitude=oldamp-powf((float)note_time/release,ampshape)*oldamp;
			else
				amplitude=0.0f;
		}

		if(amplitude!=0)
		{
			if(oscphase<pulsewidth)								//OSCILLATOR
				*psamples=powf(oscphase/pulsewidth,oscshape);
			else
				*psamples=1-powf((oscphase-pulsewidth)/(1-pulsewidth),oscshape);
					
				*psamples-=0.5f;					
				*psamples *= (2*amplitude*level);
		}
				
		psamples++;	
		oscphase+=frequency/pMasterInfo->SamplesPerSec;
		if(oscphase>=1)
			oscphase-=1;
		note_time++;
	};

	return(amplitude!=0);

}
